/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////
#include <..\OriginLab\oMatlab.h>
//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
//add two matrix
void test_add_matrix()
{
	vector vIn1 = {1,2,3,4,5,6,7,8,9};
	vector vIn2 = {1,2,3,4,5,6,7,8,9};
	/**
	Notes: in Matlab, matrix data are put and treated at column-wise, so in the point view of Matlab, vIn1 will seems like this:
		vIn1 matrix
		1, 4, 7
		2, 5, 8
		3, 6, 9
	*/
	vector vOut(9);
	bool bRet = omatlab_add_matrix(vIn1, 3, 3, vIn2, 3, 3, vOut);
	for ( int ii = 0; ii < 3; ii++ )
	{
		for ( int jj = 0; jj < 3; jj++ )
		{
			printf("%g\t", vOut[ii + 3 * jj]); //buffer in matlab is column-wise!!!
		}
		printf("\n");
	}
}
//get the data in column cells
#define	GET_COLUMN_DATA(_wks, _index, _vector)	{ \
	Column _col = _wks.Columns(_index);	\
	vectorbase& vb = _col.GetDataObject();	\
	_vector = vb;	\
}

//set the data in the vector to column cells
#define	ASSIGN_COLUMN(_wks, _index, _vector)	{ \
	Column _col = _wks.Columns(_index);	\
	vectorbase& vb = _col.GetDataObject();	\
	vb = _vector;	\
}
//set the longname field of a column
#define	LABEL_COLUMN(_wks, _index, _label)	{	\
	Column _col = _wks.Columns(_index);	\
	_col.SetLabel(_label);	\
}
void test_gauss_fit()
{
	//vector vXIn = {1,2,3,4,5,6,7,8,9,10};
	//vector vYIn = {1,2,3,4,5,4,3,2,1,0};
	vector vXIn, vYIn, vParams0, vXOut;
	Worksheet wks = Project.ActiveLayer(); //get input from and dump result to the active worksheet.
	if ( wks )
	{
		wks.SetSize(-1, 7);
		GET_COLUMN_DATA(wks, 0, vXIn);
		GET_COLUMN_DATA(wks, 1, vYIn);
		GET_COLUMN_DATA(wks, 3, vParams0);
		GET_COLUMN_DATA(wks, 4, vXOut);
	}
	else
	{
		return;
	}
	vector vParams;
	vParams = vParams0;
	vector vYOut(vXOut.GetSize());
	omatlab_gauss_fit(vXIn, vYIn, vXIn.GetSize(), vParams, vXOut, vYOut, vXOut.GetSize());

	if ( wks )
	{
		ASSIGN_COLUMN(wks, 5, vYOut);
		LABEL_COLUMN(wks, 5, "Fitted Y");
		ASSIGN_COLUMN(wks, 6, vParams);
		LABEL_COLUMN(wks, 6, "Fitted Parameters");
	}
	return;
}

//this is the main function to testing APIs in oMatlab.dll
///!!! Notes: This testing procedure might modify the project file, so please save your current project and run it within a New Project!!!///
void test_omatlab_main()
{
	if ( omatlab_init() ) //this need to be call before call any oMatlab API
	{
		test_add_matrix();
		test_gauss_fit();
		omatlab_free();//need to free resources
	}
}
